<?php
define('_VALID', true);
require 'include/config.php';
require 'classes/filter.class.php';
require 'classes/validation.class.php';
require 'include/function_smarty.php';

if ( isset($_GET['id']) && isset($_GET['code']) ) {
    $filter     = new VFilter();
    $uid        = $filter->get('id', 'INTEGER', 'GET');
    $code       = $filter->get('code', 'STRING', 'GET');
    $length     = strlen($code);
    
    if ( !$uid ) {
        $errors[]   = 'Invalid verification id! Are you sure this id is correct?!';
    }
        
    if ( $length != 10 ) {
        $errors[]   = 'Invalid verification code! Are you sure this code is correct?!';
    }
    
    if ( !$errors ) {
        $sql        = "SELECT emailverified FROM signup WHERE UID = " .$uid. " LIMIT 1";
        $rs         = $conn->execute($sql);
        $verified   = $rs->fields['emailverified'];
        if ( $verified == 'yes' ) {
            $sql            = "DELETE FROM confirm WHERE UID = " .$uid;
            $conn->execute($sql);
            $messages[] = 'You already confirmed your email address!';
        } else {
            $sql    = "SELECT UID FROM confirm WHERE UID = " .$uid. " AND code = '" .mysql_real_escape_string($code). "' LIMIT 1";
            $conn->execute($sql);
            if ( $conn->Affected_Rows() == 1 ) {        
                $sql            = "DELETE FROM confirm WHERE UID = " .$uid;
                $conn->execute($sql);
                $sql    = "UPDATE signup SET emailverified = 'yes' WHERE UID = " .$uid. " LIMIT 1";
                $conn->execute($sql);
                if ( isset($_SESSION['uid']) ) {
                    $_SESSION['emailverified'] = 'yes';
                }
                $messages[]     = 'Email was successfully verified!';
            } else {
                $errors[]       = 'Invalid confirmation id and/or code!';
            }
        }
    }
}

if ( isset($_POST['submit_confirm']) ) {
    $filter     = new VFilter();
    $valid      = new VValidation();
    $email      = $filter->get('email');

    if ( $email == '' ) {
        $errors[]   = 'Please enter your email which you first registered with!';
    } elseif ( !$valid->email($email) ) {
        $errors[]   = 'Email is not a valid email address!';
    } elseif ( !$valid->emailExists($email) ) {
        $errors[]   = 'There is no user with this email!';
    } else {
        require 'classes/random.class.php';
		require 'classes/email.class.php';
        
        $sql            = "SELECT UID, username FROM signup WHERE email = '" .mysql_real_escape_string($email). "' LIMIT 1";
        $rs             = $conn->execute($sql);
        $uid            = $rs->fields['UID'];
        $username       = $rs->fields['username'];
        $code           = VRandom::generate(10, 'confirmation');
        $sql            = "DELETE FROM confirm WHERE UID = " .$uid;
        $conn->execute($sql);
        $sql            = "INSERT INTO confirm (UID, code) VALUES (" .$uid. ",'" .mysql_real_escape_string($code). "')";
        $conn->execute($sql);
        $sql            = "SELECT email_subject, email_path FROM emailinfo 
                           WHERE email_id = 'verify_email' LIMIT 1";
        $rs             = $conn->execute($sql);
        $email_subject  = str_replace('{$site_name}', $config['site_name'], $rs->fields['email_subject']);
        $email_path     = $config['BASE_DIR']. '/templates/' .$rs->fields['email_path'];
        $smarty->assign('username', $username);
        $smarty->assign('uid', $uid);
        $smarty->assign('code', $code);
        $body           = $smarty->fetch($email_path);
        $mail           = new VMail();
        $mail->setNoReply();
        $mail->Subject  = $email_subject;
        $mail->AltBody  = $body;
        $mail->Body     = nl2br($body);
        $mail->AddAddress($email);
        $mail->Send();
        $messages[]     = 'Confirmation email was successfully sent!';
    }
}

$smarty->assign('errors',$errors);
$smarty->assign('messages',$messages);
$smarty->assign('menu', 'home');
$smarty->assign('self_title', $seo['confirm_title']);
$smarty->assign('self_description', $seo['confirm_desc']);
$smarty->assign('self_keywords', $seo['confirm_keywords']);
$smarty->display('header.tpl');
$smarty->display('errors.tpl');
$smarty->display('messages.tpl');
$smarty->display('confirm.tpl');
$smarty->display('footer.tpl');
$smarty->gzip_encode();
?>
